package gov.va.med.mhv.bluebutton.repository;

import java.sql.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import gov.va.med.mhv.bluebutton.model.MhvDownloadReport;


public interface MhvDownloadReportRepository extends JpaRepository<MhvDownloadReport, Long> {
	
	@Query(value ="SELECT * FROM (SELECT * FROM MHV_DOWNLOAD_REPORT  "
			+ "WHERE USER_PROFILE_ID = ?1"
			+ " ORDER BY CREATED_DATE DESC) WHERE ROWNUM =1", nativeQuery=true)
	List<MhvDownloadReport> findLatestReportByUserProfileId(Long userProfileId);

	@Query(value ="CALL MHVREPORTCREATE(?1,?2,?3,?4,?5,?6)", nativeQuery=true)
	public void generateDownload(long userId, String options, Date start, Date end, 
					long dateSelection, long typeSelection);
	
	@Query("select r from MhvDownloadReport r where r.downloadReportId = :downloadReportId")
	MhvDownloadReport findByReportId(@Param("downloadReportId") Long downloadReportId);
}
